/*
 * Decompiled with CFR 0.152.
 */
package org.agmas.harpymodloader.modded_murder;

import dev.doctor4t.wathe.api.Role;
import dev.doctor4t.wathe.api.WatheRoles;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.cca.ScoreboardRoleSelectorComponent;
import dev.doctor4t.wathe.cca.TrainWorldComponent;
import dev.doctor4t.wathe.client.gui.RoleAnnouncementTexts;
import dev.doctor4t.wathe.game.gamemode.MurderGameMode;
import dev.doctor4t.wathe.util.AnnounceWelcomePayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import org.agmas.harpymodloader.Harpymodloader;
import org.agmas.harpymodloader.component.WorldModifierComponent;
import org.agmas.harpymodloader.config.HarpyModLoaderConfig;
import org.agmas.harpymodloader.events.ModdedRoleAssigned;
import org.agmas.harpymodloader.events.ModifierAssigned;
import org.agmas.harpymodloader.events.ResetPlayerEvent;
import org.agmas.harpymodloader.modded_murder.ModdedWeights;
import org.agmas.harpymodloader.modifiers.HMLModifiers;
import org.agmas.harpymodloader.modifiers.Modifier;
import org.jetbrains.annotations.NotNull;

public class ModdedMurderGameMode
extends MurderGameMode {
    public ModdedMurderGameMode(class_2960 identifier) {
        super(identifier);
    }

    public void finalizeGame(class_3218 serverWorld, GameWorldComponent gameWorldComponent) {
        WorldModifierComponent worldModifierComponent = (WorldModifierComponent)WorldModifierComponent.KEY.get((Object)serverWorld);
        worldModifierComponent.getModifiers().clear();
        super.finalizeGame(serverWorld, gameWorldComponent);
    }

    public void initializeGame(class_3218 serverWorld, GameWorldComponent gameWorldComponent, List<class_3222> players) {
        Harpymodloader.refreshRoles();
        HarpyModLoaderConfig.HANDLER.load();
        ((TrainWorldComponent)TrainWorldComponent.KEY.get((Object)serverWorld)).setTimeOfDay(TrainWorldComponent.TimeOfDay.NIGHT);
        gameWorldComponent.clearRoleMap();
        for (class_3222 player : players) {
            ((ResetPlayerEvent)ResetPlayerEvent.EVENT.invoker()).resetPlayer((class_1657)player);
            gameWorldComponent.addRole((class_1657)player, WatheRoles.CIVILIAN);
        }
        int roleCount = this.assignVannilaRoles(serverWorld, gameWorldComponent, players);
        this.assignCivilianReplacingRoles(roleCount, serverWorld, gameWorldComponent, players);
        this.assignKillerReplacingRoles(roleCount, serverWorld, gameWorldComponent, players);
        int modifierRoleCount = roleCount * ((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).modifierMultiplier;
        this.assignModifiers(modifierRoleCount, serverWorld, gameWorldComponent, players);
        for (class_3222 player : players) {
            if (Harpymodloader.VANNILA_ROLES.contains(gameWorldComponent.getRole((class_1657)player))) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new AnnounceWelcomePayload(RoleAnnouncementTexts.ROLE_ANNOUNCEMENT_TEXTS.indexOf(gameWorldComponent.isRole((class_1657)player, WatheRoles.KILLER) ? RoleAnnouncementTexts.KILLER : (gameWorldComponent.isRole((class_1657)player, WatheRoles.VIGILANTE) ? RoleAnnouncementTexts.VIGILANTE : RoleAnnouncementTexts.CIVILIAN)), roleCount, players.size() - roleCount));
                continue;
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)new AnnounceWelcomePayload(RoleAnnouncementTexts.ROLE_ANNOUNCEMENT_TEXTS.indexOf(Harpymodloader.autogeneratedAnnouncements.get(gameWorldComponent.getRole((class_1657)player))), roleCount, players.size() - roleCount));
        }
        Harpymodloader.FORCED_MODDED_ROLE.clear();
        Harpymodloader.FORCED_MODDED_ROLE_FLIP.clear();
        Harpymodloader.FORCED_MODDED_MODIFIER.clear();
    }

    public void assignModifiers(int desiredRoleCount, class_3218 serverWorld, GameWorldComponent gameWorldComponent, List<class_3222> players) {
        WorldModifierComponent worldModifierComponent = (WorldModifierComponent)WorldModifierComponent.KEY.get((Object)serverWorld);
        worldModifierComponent.getModifiers().clear();
        int killerMods = (int)HMLModifiers.MODIFIERS.stream().filter(modifier -> modifier.killerOnly).count();
        HMLModifiers.MODIFIERS.forEach(mod -> {
            int playersAssigned = 0;
            int specificDesiredRoleCount = desiredRoleCount;
            if (mod.killerOnly) {
                specificDesiredRoleCount = (int)Math.floor(Math.floor((double)players.size() / (double)gameWorldComponent.getKillerDividend()) / (double)killerMods);
                specificDesiredRoleCount = Math.max(specificDesiredRoleCount, 1);
            }
            ArrayList shuffledPlayers = new ArrayList(players);
            Collections.shuffle(shuffledPlayers);
            if (Harpymodloader.FORCED_MODDED_MODIFIER.containsKey(mod)) {
                for (class_3222 player : shuffledPlayers) {
                    if (!Harpymodloader.FORCED_MODDED_MODIFIER.get(mod).contains(player.method_5667())) continue;
                    worldModifierComponent.addModifier(player.method_5667(), (Modifier)mod);
                    ((ModifierAssigned)ModifierAssigned.EVENT.invoker()).assignModifier((class_1657)player, (Modifier)mod);
                    ++playersAssigned;
                }
            }
            for (class_3222 player : shuffledPlayers) {
                if (((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).disabledModifiers.contains(mod.identifier.toString()) || playersAssigned >= specificDesiredRoleCount || Harpymodloader.MODIFIER_MAX.containsKey(mod.identifier) && playersAssigned >= Harpymodloader.MODIFIER_MAX.get(mod.identifier)) continue;
                boolean valid = true;
                if (mod.canOnlyBeAppliedTo != null && gameWorldComponent.getRole((class_1657)player) != null) {
                    valid = mod.canOnlyBeAppliedTo.contains(gameWorldComponent.getRole((class_1657)player));
                }
                if (mod.cannotBeAppliedTo != null && gameWorldComponent.getRole((class_1657)player) != null) {
                    boolean bl = valid = !mod.cannotBeAppliedTo.contains(gameWorldComponent.getRole((class_1657)player));
                }
                if (!valid) continue;
                if (mod.killerOnly) {
                    valid = gameWorldComponent.canUseKillerFeatures((class_1657)player);
                }
                if (mod.civilianOnly) {
                    boolean bl = valid = !gameWorldComponent.canUseKillerFeatures((class_1657)player);
                }
                if (!valid) continue;
                if (worldModifierComponent.getModifiers((class_1657)player) != null && worldModifierComponent.getModifiers((class_1657)player).size() >= ((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).modifierMaximum) {
                    valid = false;
                }
                if (!valid) continue;
                worldModifierComponent.addModifier(player.method_5667(), (Modifier)mod);
                ((ModifierAssigned)ModifierAssigned.EVENT.invoker()).assignModifier((class_1657)player, (Modifier)mod);
                ++playersAssigned;
            }
        });
        for (class_3222 player : players) {
            if (!worldModifierComponent.getModifiers((class_1657)player).isEmpty()) {
                class_5250 modifiersText = class_2561.method_43471((String)"announcement.modifier").method_27692(class_124.field_1080).method_10852((class_2561)class_2564.method_36332(worldModifierComponent.getModifiers((class_1657)player), (class_2561)class_2561.method_43470((String)", "), modifier -> modifier.getName(false).method_54663(modifier.color)));
                player.method_7353((class_2561)modifiersText, true);
                continue;
            }
            if (HMLModifiers.MODIFIERS.isEmpty()) continue;
            player.method_7353((class_2561)class_2561.method_43471((String)"announcement.no_modifiers").method_27692(class_124.field_1063), true);
        }
    }

    public void assignCivilianReplacingRoles(int desiredRoleCount, class_3218 serverWorld, GameWorldComponent gameWorldComponent, List<class_3222> players) {
        ArrayList<Role> shuffledCivillianRoles = new ArrayList<Role>(WatheRoles.ROLES);
        shuffledCivillianRoles.removeIf(role -> Harpymodloader.VANNILA_ROLES.contains(role) || role.canUseKiller() || !role.isInnocent());
        ArrayList<Role> shuffledNeutralRoles = new ArrayList<Role>(WatheRoles.ROLES);
        shuffledNeutralRoles.removeIf(role -> Harpymodloader.VANNILA_ROLES.contains(role) || role.canUseKiller() || role.isInnocent());
        ArrayList<class_3222> playersForCivillianRoles = new ArrayList<class_3222>(players);
        playersForCivillianRoles.removeIf(player -> {
            Role role = gameWorldComponent.getRole((class_1657)player);
            return !Harpymodloader.OVERWRITE_ROLES.contains(role) || role.canUseKiller();
        });
        Collections.shuffle(shuffledCivillianRoles);
        Collections.shuffle(shuffledNeutralRoles);
        int neutralDesiredRoleCount = (int)Math.floor((float)players.size() / (float)gameWorldComponent.getKillerDividend());
        int assignedNeutralRoles = 0;
        int neutralRoleCount = 0;
        for (Role role2 : shuffledNeutralRoles) {
            if (((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).disabled.contains(role2.identifier().toString())) continue;
            ++neutralRoleCount;
        }
        for (Role role2 : shuffledNeutralRoles) {
            if (((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).disabled.contains(role2.identifier().toString()) || assignedNeutralRoles >= neutralDesiredRoleCount) continue;
            int roleSpecificDesireCount = Math.min((int)Math.ceil((double)playersForCivillianRoles.size() / (double)neutralRoleCount), desiredRoleCount);
            if (Harpymodloader.ROLE_MAX.containsKey(role2.identifier())) {
                roleSpecificDesireCount = Harpymodloader.ROLE_MAX.get(role2.identifier());
            }
            assignedNeutralRoles += ModdedMurderGameMode.findAndAssignPlayers(roleSpecificDesireCount, role2, playersForCivillianRoles, gameWorldComponent, (class_1937)serverWorld);
            playersForCivillianRoles.removeIf(player -> {
                Role role2 = gameWorldComponent.getRole((class_1657)player);
                return !Harpymodloader.OVERWRITE_ROLES.contains(role2);
            });
        }
        playersForCivillianRoles.removeIf(player -> {
            Role role = gameWorldComponent.getRole((class_1657)player);
            return !role.isInnocent();
        });
        int roleCount = 0;
        for (Role role3 : shuffledCivillianRoles) {
            if (((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).disabled.contains(role3.identifier().toString())) continue;
            ++roleCount;
        }
        for (Role role4 : shuffledCivillianRoles) {
            if (((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).disabled.contains(role4.identifier().toString())) continue;
            int roleSpecificDesireCount = Math.min((int)Math.max(Math.round((double)playersForCivillianRoles.size() / (double)roleCount), 1L), desiredRoleCount);
            if (Harpymodloader.ROLE_MAX.containsKey(role4.identifier())) {
                roleSpecificDesireCount = Harpymodloader.ROLE_MAX.get(role4.identifier());
            }
            ModdedMurderGameMode.findAndAssignPlayers(roleSpecificDesireCount, role4, playersForCivillianRoles, gameWorldComponent, (class_1937)serverWorld);
            playersForCivillianRoles.removeIf(player -> {
                Role role2 = gameWorldComponent.getRole((class_1657)player);
                return !Harpymodloader.OVERWRITE_ROLES.contains(role2);
            });
        }
    }

    public void assignKillerReplacingRoles(int desiredRoleCount, class_3218 serverWorld, GameWorldComponent gameWorldComponent, List<class_3222> players) {
        ArrayList<Role> shuffledKillerRoles = new ArrayList<Role>(WatheRoles.ROLES);
        shuffledKillerRoles.removeIf(role -> Harpymodloader.VANNILA_ROLES.contains(role) || !role.canUseKiller());
        ArrayList<class_3222> playersForKillerRoles = new ArrayList<class_3222>(players);
        playersForKillerRoles.removeIf(player -> {
            Role role = gameWorldComponent.getRole((class_1657)player);
            return !Harpymodloader.OVERWRITE_ROLES.contains(role) || !role.canUseKiller();
        });
        Collections.shuffle(shuffledKillerRoles);
        int roleCount = 0;
        for (Role role2 : shuffledKillerRoles) {
            if (((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).disabled.contains(role2.identifier().toString())) continue;
            ++roleCount;
        }
        for (Role role2 : shuffledKillerRoles) {
            if (((HarpyModLoaderConfig)HarpyModLoaderConfig.HANDLER.instance()).disabled.contains(role2.identifier().toString())) continue;
            int roleSpecificDesireCount = Math.min((int)Math.max(Math.round((double)playersForKillerRoles.size() / (double)roleCount), 1L), desiredRoleCount);
            if (Harpymodloader.ROLE_MAX.containsKey(role2.identifier())) {
                roleSpecificDesireCount = Harpymodloader.ROLE_MAX.get(role2.identifier());
            }
            ModdedMurderGameMode.findAndAssignPlayers(roleSpecificDesireCount, role2, playersForKillerRoles, gameWorldComponent, (class_1937)serverWorld);
            playersForKillerRoles.removeIf(player -> {
                Role role2 = gameWorldComponent.getRole((class_1657)player);
                return !Harpymodloader.OVERWRITE_ROLES.contains(role2);
            });
        }
    }

    private static int findAndAssignPlayers(int desiredRoleCount, Role role, @NotNull List<class_3222> players, GameWorldComponent gameWorldComponent, class_1937 world) {
        int i;
        ArrayList<class_3222> assignedPlayers = new ArrayList<class_3222>();
        if (Harpymodloader.FORCED_MODDED_ROLE.containsKey(role)) {
            for (UUID uuid : Harpymodloader.FORCED_MODDED_ROLE.get(role)) {
                class_3222 serverPlayer;
                class_1657 player = world.method_18470(uuid);
                if (!(player instanceof class_3222) || !players.contains(serverPlayer = (class_3222)player)) continue;
                assignedPlayers.add(serverPlayer);
                --desiredRoleCount;
                ModdedWeights.roleRounds.get(role).put(player.method_5667(), ModdedWeights.roleRounds.get(role).getOrDefault(player.method_5667(), 1) + 1);
            }
        }
        HashMap<class_3222, Float> map = new HashMap<class_3222, Float>();
        float total = 0.0f;
        for (class_3222 player : players) {
            if (Harpymodloader.FORCED_MODDED_ROLE_FLIP.containsKey(player.method_5667()) || !Harpymodloader.OVERWRITE_ROLES.contains(gameWorldComponent.getRole((class_1657)player))) continue;
            float weight = (float)Math.exp(-ModdedWeights.roleRounds.get(role).getOrDefault(player.method_5667(), 1).intValue() * 4);
            if (!gameWorldComponent.areWeightsEnabled()) {
                weight = 1.0f;
            }
            map.put(player, Float.valueOf(weight));
            total += weight;
        }
        block2: for (i = 0; i < desiredRoleCount; ++i) {
            float random = world.method_8409().method_43057() * total;
            for (Map.Entry entry : map.entrySet()) {
                if (Harpymodloader.FORCED_MODDED_ROLE_FLIP.containsKey(((class_3222)entry.getKey()).method_5667()) || !Harpymodloader.OVERWRITE_ROLES.contains(gameWorldComponent.getRole((class_1657)entry.getKey())) || !((random -= ((Float)entry.getValue()).floatValue()) <= 0.0f)) continue;
                assignedPlayers.add((class_3222)entry.getKey());
                total -= ((Float)entry.getValue()).floatValue();
                map.remove(entry.getKey());
                ModdedWeights.roleRounds.get(role).put(((class_3222)entry.getKey()).method_5667(), ModdedWeights.roleRounds.get(role).getOrDefault(((class_3222)entry.getKey()).method_5667(), 1) + 1);
                continue block2;
            }
        }
        i = 0;
        for (class_3222 player : assignedPlayers) {
            gameWorldComponent.addRole((class_1657)player, role);
            Log.info((LogCategory)LogCategory.GENERAL, (String)(player.method_5820() + " || " + String.valueOf(role.identifier())));
            ((ModdedRoleAssigned)ModdedRoleAssigned.EVENT.invoker()).assignModdedRole((class_1657)player, role);
            ++i;
        }
        return i;
    }

    public int assignVannilaRoles(class_3218 serverWorld, GameWorldComponent gameWorldComponent, List<class_3222> players) {
        ScoreboardRoleSelectorComponent roleSelector = (ScoreboardRoleSelectorComponent)ScoreboardRoleSelectorComponent.KEY.get((Object)serverWorld.method_14170());
        int killerCount = (int)Math.floor((float)players.size() / (float)gameWorldComponent.getKillerDividend());
        int vigilanteCount = (int)Math.floor((float)players.size() / (float)gameWorldComponent.getVigilanteDividend());
        ArrayList<class_3222> playersForVigilante = new ArrayList<class_3222>(players);
        playersForVigilante.removeIf(player -> Harpymodloader.FORCED_MODDED_ROLE_FLIP.containsKey(player.method_5667()));
        ArrayList<class_3222> playersForKiller = new ArrayList<class_3222>(players);
        playersForKiller.removeIf(player -> {
            if (Harpymodloader.FORCED_MODDED_ROLE_FLIP.containsKey(player.method_5667())) {
                if (Harpymodloader.FORCED_MODDED_ROLE_FLIP.get(player.method_5667()).canUseKiller()) {
                    roleSelector.forcedKillers.add(player.method_5667());
                    return false;
                }
                return true;
            }
            return false;
        });
        int total = roleSelector.assignKillers(serverWorld, gameWorldComponent, playersForVigilante, killerCount);
        roleSelector.assignVigilantes(serverWorld, gameWorldComponent, playersForKiller, vigilanteCount);
        return total;
    }
}

